<?php
  $planCaption = getContent('plan.content',true);
  $plans = App\Models\Plan::where('status',1)->where('featured', 1)->get();
  $gatewayCurrency = null;
  if(auth()->check()){
    $gatewayCurrency = App\Models\GatewayCurrency::whereHas('method', function ($gate) {
            $gate->where('status', 1);
        })->with('method')->orderby('method_code')->get();
  }
?>
<section class="pt-120 pb-120">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-6 text-center">
        <div class="section-header">
          <h2 class="section-title"><span class="font-weight-normal"><?php echo e(__(@$planCaption->data_values->heading_w)); ?></span> <b class="base--color"><?php echo e(__(@$planCaption->data_values->heading_c)); ?></b></h2>
          <p><?php echo e(__(@$planCaption->data_values->sub_heading)); ?></p>
        </div>
      </div>
    </div><!-- row end -->
    <div class="row gy-4 justify-content-center">
        <?php echo $__env->make($activeTemplate.'partials.plan', ['plans' => $plans], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
  </div>
</section>

<?php /**PATH /home/u452099573/domains/alpha7x.com/public_html/core/resources/views/templates/bit_gold/sections/plan.blade.php ENDPATH**/ ?>